import {myApiPromisify} from '../../utils/index';
const {cloud} = getApp();
const defaultUrl = 'https://gw.alicdn.com/tfs/TB110kENgHqK1RjSZFgXXa7JXXa-200-200.png';

Page({
  data: {
    imageUrl: defaultUrl,
    res: '',
    uploading: false
  },
  
  preview() {
    my.previewImage({
      urls: [this.data.imageUrl], 
    });
  },

  async uploadHandler() {
    let images = await myApiPromisify(my.chooseImage);
    this.setData({uploading: true});
    try{
      const resource = await cloud.file.uploadFile({
        filePath: images.apFilePaths[0],
        fileType: 'image',
        fileName: 'OOO/test.png'
      })
      this.setData({
        res: JSON.stringify(resource),
        imageUrl: resource.url,
        fileId:resource.fileId,
        uploading: false,
      })
    } catch (e) {
      this.setData({
        uploading: false,
        res: 'error' + (e.message || JSON.stringify(e))
      })
    }
  },
 
});
