package com.taobao.miniapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Updates;
import com.taobao.miniapp.database.CloudDoc;
import com.taobao.miniapp.database.CloudCollection;
import com.taobao.miniapp.database.CloudDB;

import com.taobao.miniapp.database.OrderBy;
import com.taobao.miniapp.database.Result;
import com.taobao.miniapp.function.anotation.RequestHandler;
import com.taobao.miniapp.function.runtime.FunctionContext;
import org.bson.Document;
import org.bson.conversions.Bson;
import static com.mongodb.client.model.Filters.*;
import static com.mongodb.client.model.Sorts.*;

/**
 * @author zhaoqingjie
 * @create 2019 - 06 - 17 -18:08
 */
@RequestHandler
public class JavaSDKTest {

    private static String COLLECTION_NAME = "users";

    @Resource
    private CloudDB db;

    String docId = "";

    /**
     * OK
     */
    @RequestHandler("createCollection")
    public Result createCollection() {
        System.out.println("miniappId" + FunctionContext.getMiniappId());
        System.out.println("appKey" +FunctionContext.getAppKey());
        System.out.println("cloudId" +FunctionContext.getCloudId());

        Result<Boolean> result = db.createCollection(COLLECTION_NAME);
        return result;
    }

    public static void main(String[] args) {

    }

    @RequestHandler("addMany")
    public Result addMany() {

        List<Document> addRecords = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            addRecords.add(new Document("lname", "name" + i).append("student_id", i).append("type", "exam").append("course", "Math").append("score", 100 - 5 * i).append("rank", i + 1).append("age", 12 + i));
            addRecords.add(new Document("lname", "name" + i).append("student_id", i).append("type", "exam").append("course", "English").append("score", 100 - 8 * i).append("rank", i + 1).append("age", 12 + i));
        }
        Result<List<String>> result = db.collection(COLLECTION_NAME).addMany(addRecords);

        return result;
    }

    @RequestHandler("addManyJson")
    public Result addManyJson() {

        String jsonData = "[\n" +
            "    {\n" +
            "        \"lname\":\"name10\",\n" +
            "        \"student_id\":10,\n" +
            "        \"type\":\"exam\",\n" +
            "        \"course\":\"Math\",\n" +
            "        \"score\":50,\n" +
            "        \"rank\":11,\n" +
            "        \"age\":22\n" +
            "    },\n" +
            "    {\n" +
            "        \"lname\":\"name10\",\n" +
            "        \"student_id\":10,\n" +
            "        \"type\":\"exam\",\n" +
            "        \"course\":\"English\",\n" +
            "        \"score\":20,\n" +
            "        \"rank\":11,\n" +
            "        \"age\":22\n" +
            "    }\n" +
            "]";
        Result<List<String>> result = db.collection(COLLECTION_NAME).addMany(jsonData);
        return result;
    }

    @RequestHandler("add")
    public Result add() {

        Result<String> result = db.collection(COLLECTION_NAME).add(new Document("lname", "name6").append("student_id", 6).append("type", "exam").append("course", "Math").append("score", 60).append("rank", 6).append("age", 20));
        return result;
    }

    @RequestHandler("addJson")
    public Result addJson() {

        String json = "{\n" +
            "        \"lname\":\"name7\",\n" +
            "            \"student_id\":7,\n" +
            "            \"type\":\"exam\",\n" +
            "            \"course\":\"English\",\n" +
            "            \"score\":55,\n" +
            "            \"rank\":6,\n" +
            "            \"age\":20\n" +
            "    }";
        Result<String> result = db.collection(COLLECTION_NAME).add(json);
        return result;
    }


    @RequestHandler("getAll")
    public Result getAll() {

        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("student_id");
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).fields(fields).orderby("age", OrderBy.DESC).get();
        //docId = result.getData().get(0).get("_id").toString();
        return result;
    }


    @RequestHandler("get")
    public Result get() {

        QueryBuilder qb = new QueryBuilder();
        DBObject filter = qb.or(new QueryBuilder().put("type").is("exam").put("rank").lessThan(2).get(),
                                new QueryBuilder().put("age").lessThanEquals(13).get()).get();
        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("student_id");
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).filter(filter).orderby("age", OrderBy.ASC).limit(2).fields(fields).get();
        return result;

    }


    @RequestHandler("count")
    public Result count() {

        final CloudCollection collection = db.collection(COLLECTION_NAME);
        Result<Long> result = collection.count();
        return result;

    }

    @RequestHandler("getAndcount")
    public   Map<String,Result> getAndcount() {
        Map<String,Result> resultMap = new HashMap<>();
        QueryBuilder qb = new QueryBuilder();
        DBObject filter = qb.or(new QueryBuilder().put("type").is("exam").put("rank").lessThan(2).get(),
                                new QueryBuilder().put("age").lessThanEquals(13).get()).get();
        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("student_id");
        final CloudCollection collection = db.collection(COLLECTION_NAME);
        Result<List<Map<String, Object>>> result = collection.filter(filter).orderby("age", OrderBy.ASC).limit(2).fields(fields).get();
        Result<Long> result1 = collection.count();
        resultMap.put("getAndcount get ", result);
        resultMap.put("getAndcount count ", result1);

        return resultMap;

    }

    @RequestHandler("getException")
    public Result getException() {

        Bson test = null;
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).filter(test).get();
        return result;
    }


    @RequestHandler("getFilter0")
    public Result getFilter0() {

        Bson filter1 = or(and(eq("type", "exam"), lt("rank", 5)), lte("age", 13));
        Bson sort = orderBy(ascending("age"), descending("rank"));
        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("rank");
        Result<List<Map<String, Object>>> result = db
            .collection(COLLECTION_NAME).filter(filter1).orderby(sort).skip(2).limit(10).fields(fields).get();

        return result;

    }


    @RequestHandler("getFilterOder")
    public Result getFilterOder() {

        Bson filter1 = or(and(eq("type", "exam"), lt("rank", 5)), lte("age", 13));
        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("rank");
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).filter(filter1).orderby("age", OrderBy.ASC).orderby("rank", OrderBy.DESC).skip(2).limit(10).fields(fields).get();

        return result;

    }


    @RequestHandler("getJson")
    public Result getJson() {

        String jsonString = "{\n" +
            "    \"filter\":{\n" +
            "        \"$or\":[\n" +
            "            {\n" +
            "                \"type\":\"exam\",\n" +
            "                \"rank\":{\n" +
            "                    \"$lt\":2\n" +
            "                }\n" +
            "            },\n" +
            "            {\n" +
            "                \"age\":{\n" +
            "                    \"$lte\":13\n" +
            "                }\n" +
            "            }\n" +
            "        ]\n" +
            "    },\n" +
            "    \"order_by\":{\n" +
            "        \"age\":1\n" +
            "    },\n" +
            "    \"limit\":2,\n" +
            "    \"displayed_fields\":[\n" +
            "        \"lname\",\n" +
            "        \"age\",\n" +
            "        \"student_id\"\n" +
            "    ]\n" +
            "}";
        //        String test = null;
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).get(jsonString);

        return result;


    }


    /**
     * Updates??????
     * ??????OK
     */
    @RequestHandler("updates")
    public Result updates() {

        QueryBuilder qb1 = new QueryBuilder();
        DBObject updateWhere = qb1.and(new QueryBuilder().put("lname").is("name4").get(),
                                       new QueryBuilder().put("age").greaterThan(10).get()).get();
        Bson action = Updates.combine(Updates.inc("age", -10), Updates.set("lname", "updateName"));
        Result<Long> result = db.collection(COLLECTION_NAME).filter(updateWhere).update(action);

        return result;

    }

    @RequestHandler("updateJson")
    public Result updateJson() {

        QueryBuilder qb1 = new QueryBuilder();
        DBObject updateWhere = qb1.and(new QueryBuilder().put("lname").is("updateName").get(),
                                       new QueryBuilder().put("age").lessThan(10).get()).get();
        String json = "{\n" +
            "    \"$inc\":{\n" +
            "        \"age\":10\n" +
            "    },\n" +
            "    \"$set\":{\n" +
            "        \"lname\":\"name4\"\n" +
            "    }\n" +
            "}";
        Result<Long> result = db.collection(COLLECTION_NAME).filter(updateWhere).update(json);

        return result;

    }

    @RequestHandler("updateFilterJson")
    public Result updateFilterJson() {

        String filter = "{\n" +
            "    \"$and\":[\n" +
            "        {\n" +
            "            \"lname\":\"name6\"\n" +
            "        },\n" +
            "        {\n" +
            "            \"age\":{\n" +
            "                \"$gt\":9\n" +
            "            }\n" +
            "        }\n" +
            "    ]\n" +
            "}";
        String json = "{\n" +
            "    \"$inc\":{\n" +
            "        \"age\":-10\n" +
            "    },\n" +
            "    \"$set\":{\n" +
            "        \"lname\":\"name7\"\n" +
            "    }\n" +
            "}";
        Bson action = Updates.combine(Updates.inc("age", 10), Updates.set("lname", "name6"));

        Result<Long> result = db.collection(COLLECTION_NAME).filter(filter).update(action);

        return result;

    }

    /**
     * ??????OK
     */
    @RequestHandler("repalce")
    public Result repalce() {

        Bson filter = and(eq("lname", "name1"), eq("course", "Math"));
        Result<Boolean> result = db.collection(COLLECTION_NAME).filter(filter).replace(new Document("lname", "nameReplace").append("student_id", 1).append("type", "exam").append("course", "Math").append("score", 66).append("rank", 10).append("age", 20));
        return result;
    }


    /**
     * ??????2 Aggregates??????
     * ??????OK
     */
    @RequestHandler("aggregates")
    public Result aggregates() {

        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).aggregate(Arrays.asList(
            Aggregates.match(and(eq("type", "exam"), gte("score", 60)))
            , Aggregates.group("$student_id", Accumulators.avg("averageScore", "$score"))
            , Aggregates.sort(orderBy(descending("averageScore")))
            , Aggregates.limit(2)));
        //                , Aggregates.project(Projections.include("student_id", "name", "age", "score", "type"))));
        return result;
    }

    /**
     * ??????OK
     */
    @RequestHandler("count0")
    public Result count0() {

        String filter = "{\n" +
            "    \"rank\":{\n" +
            "        \"$lte\":3\n" +
            "    }\n" +
            "}";
        Result<Long> result = db.collection(COLLECTION_NAME).count(filter);
        return result;

    }

    /**
     * ??????OK
     */
    @RequestHandler("docGet")
    public Result docGet() {

        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("student_id");
        Result<List<Map<String, Object>>> result = db.collection(COLLECTION_NAME).doc(docId).fields(fields).get();

        return result;

    }

    /**
     * ??????OK
     */
    @RequestHandler("docSet")
    public Result docSet() {


        Result<Boolean> result = db.collection(COLLECTION_NAME).doc(docId).set(new Document("lname", "nameDocSet").append("student_id", 1).append("type", "exam").append("course", "EnglishSet").append("score", 93).append("rank", 3).append("age", 13));

        return result;

    }

    @RequestHandler("docGetSet")
    public Map<String,Result>  docGetSet() {
        Map<String,Result> resultMap = new HashMap<>();
        CloudCollection collection = db.collection(COLLECTION_NAME);
        final CloudDoc doc = collection.doc(docId);
        List<String> fields = new ArrayList<>();
        fields.add("lname");
        fields.add("age");
        fields.add("student_id");
        Result<List<Map<String, Object>>> resultGet = doc.fields(fields).get();
        Result<Boolean> result = doc.set(new Document("lname", "nameDocSet").append("student_id", 1).append("type", "exam").append("course", "EnglishSet").append("score", 93).append("rank", 3).append("age", 13));

        resultMap.put("docGetSet get ", resultGet);
        resultMap.put("docGetSet set ", result);

        return resultMap;

    }

    /**
     * ??????OK
     */
    @RequestHandler("docUpdate")
    public Result docUpdate() {

        Bson action = Updates.combine(Updates.inc("age", 10), Updates.set("lname", "nameDocUpdate"));
        Result<Long> result = db.collection(COLLECTION_NAME).doc(docId).update(action);

        return result;

    }

    /**
     * ??????OK
     */
    @RequestHandler("docRemove")
    public Result docRemove() {

        Result<Boolean> result = db.collection(COLLECTION_NAME).doc(docId).remove();

        return result;

    }




    

    /**
     * ??????OK
     */
    @RequestHandler("remove0")
    public Result remove0() {

        Bson filter0 = lt("rank", 1);
        String filter = "{\n" +
            "    \"rank\":{\n" +
            "        \"$lte\":12\n" +
            "    }\n" +
            "}";
        Result<Boolean> result = db.collection(COLLECTION_NAME).remove(filter);
        return result;

    }
    @RequestHandler("removeById")
    public Result removeById(String id) {
        Bson filter = eq("_id", id);
        Result<Boolean> result = db.collection(COLLECTION_NAME).filter(filter).remove();
        return result;

    }
    /**
     * ??????OK
     */
    @RequestHandler("remove")
    public Result remove() {

        Bson filter = lt("age", 100);
        Result<Boolean> result = db.collection(COLLECTION_NAME).filter(filter).remove();
        return result;

    }

    @RequestHandler("testAll")
    public Map<String,Result> testAll(){
        Map<String,Result> resultMap = new HashMap<>();
        resultMap.put("createCollection",createCollection());
        resultMap.put("addMany",addMany());
        resultMap.put("addManyJson",addManyJson());
        resultMap.put("add",add());
        resultMap.put("addJson",addJson());
        resultMap.put("getAll",getAll());
        resultMap.put("get",get());
        resultMap.put("count",count());
        resultMap.putAll(getAndcount());
        resultMap.put("getFilter0",getFilter0());
        resultMap.put("getFilterOder",getFilterOder());
        resultMap.put("getJson",getJson());
        resultMap.put("updates",updates());
        resultMap.put("updateJson",updateJson());
        resultMap.put("updateFilterJson",updateFilterJson());
        resultMap.put("repalce",repalce());
        resultMap.put("aggregates",aggregates());
        resultMap.put("count0",count0());
        resultMap.put("docGet",docGet());
        resultMap.put("docSet",docSet());
        resultMap.putAll(docGetSet());
        resultMap.put("docUpdate",docUpdate());
        resultMap.put("docRemove",docRemove());
        resultMap.put("remove0",remove0());
        resultMap.put("remove",remove());
        return resultMap;

    }
}
