package com.taobao.miniapp;

import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import com.qimencloud.api.DefaultQimenCloudClient;
import com.qimencloud.api.QimenCloudRequest;
import com.qimencloud.api.QimenCloudResponse;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.MiniappUserInfoGetRequest;
import com.taobao.api.request.TimeGetRequest;
import com.taobao.api.response.MiniappUserInfoGetResponse;
import com.taobao.api.response.TimeGetResponse;
import com.taobao.miniapp.function.anotation.NotNeedLogin;
import com.taobao.miniapp.function.anotation.RequestHandler;
import com.taobao.miniapp.function.runtime.FunctionContext;

/**
 * 类描述
 *
 * @Description: java类作用描述
 * @Author: wwq
 * @CreateDate: 2019/4/10 下午7:45
 */
@RequestHandler
public class TopHandlerService {


    @RequestHandler("invokeTopApi")
    @NotNeedLogin
    public String invokeTopApi(){
        String appkey = "12345XXX";
        String appSecret = "12345XXXXXXXXXXXXXX";
        String accessToken = "12345XXXXXXXXXXXXXXXXXXX";
        TaobaoClient client = new DefaultTaobaoClient("http://gw-internal.m.mappcloud.com/invokeTopApi/online", appkey, appSecret);
        MiniappUserInfoGetRequest req = new MiniappUserInfoGetRequest();
        Map<String, String> headers = new HashMap<>();
        System.out.println(FunctionContext.getFcInvokeId());
        headers.put("fc-invoke-id", FunctionContext.getFcInvokeId());
        req.setHeaderMap(headers);
        try {
            MiniappUserInfoGetResponse rsp = client.execute(req, accessToken);
            return rsp.getBody();
        } catch (ApiException e) {
            e.printStackTrace();
            return "error";
        }
    }



    public  static String preOnline = "http://pre-gw-internal.m.mappcloud.com/invokeTopApi/online";
    public  static String preSandbox = "http://pre-gw-internal.m.mappcloud.com/invokeTopApi/sandbox";

    public  static String online = "http://gw-internal.m.mappcloud.com/invokeTopApi/online";
    public  static String sandbox = "http://gw-internal.m.mappcloud.com/invokeTopApi/sandbox";


    @NotNeedLogin
    @RequestHandler("invokeOuterTest")
    public String invokeOuterTest() {
        String url = "http://connector-internal.m.mappcloud.com/qimenForword";

        String api = "taobao.miniapp.userinfo.settest";
        Map<String,String> queryParams = new HashMap<>();
        queryParams.put("userId","1000");
        queryParams.put("userInfo","{ \"name\":\"wwq\", \"age\":18 }");
        Map<String,String> headers = new HashMap<>();
        headers.put("domain","u48nfd30l0");
        String appkey = "25107020";
        String targetAppkey = "25107020";
        String appSecret = "91e455ffd3540f724c7271c63153c326";
        DefaultQimenCloudClient client = new DefaultQimenCloudClient(url, appkey, appSecret);

        QimenCloudRequest request = new QimenCloudRequest();
        request.setApiMethodName(api);
        request.setTargetAppKey(targetAppkey);
        request.setContentType("json");
        request.setHeaderMap(headers);
        queryParams.forEach(request::addQueryParam);
        QimenCloudResponse response = null;
        try {
            response = client.execute(request);
        } catch (ApiException e) {
            e.printStackTrace();
        }

        return response.getBody();

    }



    @NotNeedLogin
    @RequestHandler("preOnlineNoToken")
    public   String preOnlineNoToken() {
        return getTime(preOnline);

    }




    @NotNeedLogin
    @RequestHandler("preOnline")
    public  String preOnline() {
        return getUser(preOnline);
    }


    @NotNeedLogin
    @RequestHandler("onlineNoToken")
    public  String onlineNoToken() {
        return getTime(online);
    }

    @NotNeedLogin
    @RequestHandler("online")
    public  String online() {
        return getUser(online);
    }





    @NotNeedLogin
    @RequestHandler("preSandbox")
    public  String preSandbox() {
        return getSandBoxTime(preSandbox);
    }

    @NotNeedLogin
    @RequestHandler("sandbox")
    public  String sandbox() {
        return getSandBoxTime(sandbox);
    }




    @NotNeedLogin
    @RequestHandler("getSessionKey") //只能用25920446的sdk调用
    public  String sessionKey() {
        final String accessToken = FunctionContext.getAccessToken();
        System.out.println(accessToken);
        return accessToken;
    }


    @NotNeedLogin
    @RequestHandler("functionContext") //只能用25920446的sdk调用
    public  String functionContext() {
        System.out.println(FunctionContext.getUnionId());
        System.out.println(FunctionContext.getAppKey());
        System.out.println(FunctionContext.getCloudId());
        System.out.println(FunctionContext.getMiniappId());
        System.out.println(FunctionContext.getAccessToken());
        System.out.println(FunctionContext.getEnv());
        System.out.println(FunctionContext.getFcInvokeId());
        System.out.println(FunctionContext.getOpenId());
        System.out.println(FunctionContext.getUserNick());
        return "{}";
    }

    @NotNeedLogin
    @RequestHandler("getUserNick") //只能用25920446的sdk调用
    public  String getUserNick() {
        final String userNick = FunctionContext.getUserNick();
        System.out.println(userNick);
        return userNick;
    }


    private String getUser(String url){

        String appkey = "25920446";
        String appSecret = "235c2ea74b332661ee837b91289d99e2";
        String accessToken = "50000300500V194750dfcpdqoeqiKks4nqeedJTGMRCzsGWchUBP00FHlabpMCfi4ME";
        TaobaoClient client = new DefaultTaobaoClient(url, appkey, appSecret);
        MiniappUserInfoGetRequest req = new MiniappUserInfoGetRequest();
        Map<String, String> headers = new HashMap<>();
        System.out.println(FunctionContext.getFcInvokeId());
        headers.put("fc-invoke-id", FunctionContext.getFcInvokeId());
        headers.put("eagleeye-traceid", FunctionContext.getFcInvokeId());
        req.setHeaderMap(headers);
        try {
            MiniappUserInfoGetResponse rsp = client.execute(req, accessToken);
            return rsp.getBody();
        } catch (ApiException e) {
            e.printStackTrace();
            return "error";
        }
    }


    private String getTime(String url){
        String appkey = "25107020";
        String appSecret = "91e455ffd3540f724c7271c63153c326";
        Map<String,String> headers = new HashMap<>();
        System.out.println(FunctionContext.getFcInvokeId());
        headers.put("fc-invoke-id", FunctionContext.getFcInvokeId());
        headers.put("eagleeye-traceid", FunctionContext.getFcInvokeId());
        TaobaoClient client = new DefaultTaobaoClient(url, appkey, appSecret);
        TimeGetRequest req = new TimeGetRequest();
        TimeGetResponse rsp = null;
        req.setHeaderMap(headers);
        System.out.println(JSONObject.toJSON(req).toString());

        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            e.printStackTrace();
        }

        System.out.println(rsp.getBody());
        return rsp.getBody();
    }


    private String getSandBoxTime(String url){
        String appkey = "1025920446";
        String appSecret = "sandbox74b332661ee837b91289d99e2";
        System.out.println(FunctionContext.getFcInvokeId());
        Map<String,String> headers = new HashMap<>();
        headers.put("fc-invoke-id", FunctionContext.getFcInvokeId());
        headers.put("eagleeye-traceid", FunctionContext.getFcInvokeId());
        TaobaoClient client = new DefaultTaobaoClient(url, appkey, appSecret);
        TimeGetRequest req = new TimeGetRequest();
        TimeGetResponse rsp = null;
        req.setHeaderMap(headers);
        System.out.println(JSONObject.toJSON(req).toString());

        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            e.printStackTrace();
        }

        System.out.println(rsp.getBody());
        return rsp.getBody();
    }



}
